package risk.demo;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.dx.mobile.risk.PrivacyFlag;
import com.dx.mobile.risk.RiskApp;
import com.dx.mobile.risk.RiskSdk;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import risk.demo.utils.FingerHelper;

public class AllFingerDemo extends Activity {

    private static final String TAG = "RiskPoc";

    private TextView showTV;
    private TextView msgTV;
    private Button showBT;
    private TextView detailTV;

    private EditText appIdET;
    private EditText appSecET;
    private EditText tokenUrlET;

    private CheckBox memdumpCB;
    private CheckBox injectCB;
    private CheckBox debugCB;
    private CheckBox emulatorCB;
    private CheckBox multirunCB;
    private CheckBox rootCB;

    private CheckBox clearCB;

    private CheckBox rememberCB;

    // saas
//    public static final String sTokenUrl = "saas";

    public static final String sUrl = "http://118.25.100.104:7801";
    public static final String sAppId = "a94b848c85f2bafd1ad3621b2dcc9329";
    public static final String sAppSecret = "54772747dc03171f435753442dee283c";


    // gz私有化
//    public static final String sUrl = "http://192.168.31.52:7775";
//    public static final String sAppId = "4e64081b1c2b3dbe7e389590ffe8b5bd";
//    public static final String sAppSecret = "320980eeecfa42afd056fb3937bb35cd";

    // 公网私有化
//    public static final String sUrl = "https://yzm-6wblp9zqs.i.dx-corp.top:8887";
//    public static final String sAppId = "1";
//    public static final String sAppSecret = "1";


    // 杭州私有化
    // public static final String sUrl = "";
    // public static final String sAppId = "c1b637485b6e73f21069046beac95967";
    // public static final String sAppSecret = "dca1cba86d0ae014ef0b42cd39d9cb56";


    // poc
    // public static final String sUrl = "https://device-finger.wanwudezhi.com";
    // public static final String sAppId = "d9e88bf772495bbc38d96cab5205e5e7";
    // public static final String sAppSecret = "70db7d234fc0e27845280e169164ebdf";


    private String mUrl;
    private String mTokenUrl;
    private String mEngineUrl;
    private String mAppId;
    private String mAppSecret;

    private String mDeviceInfo = null;

    private String mSpendTime;
    private String mUsedCpu;
    private String mUsedMem;

    HashMap<String, String> mRiskMap = new HashMap<String, String>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_poc_finger);

        initView();
        initEvent();

    }

    public void initView() {

        showTV = findViewById(R.id.show_tv);
        msgTV = findViewById(R.id.msg_tv);
        detailTV = findViewById(R.id.detail_tv);
        showBT = findViewById(R.id.show_bt);

        appIdET = findViewById(R.id.appId_et);
        appSecET = findViewById(R.id.appSec_et);
        tokenUrlET = findViewById(R.id.token_url_et);

        memdumpCB = findViewById(R.id.memdump_cb);
        injectCB = findViewById(R.id.inject_cb);
        debugCB = findViewById(R.id.debug_cb);
        emulatorCB = findViewById(R.id.emulator_cb);
        multirunCB = findViewById(R.id.multirun_cb);
        rootCB = findViewById(R.id.root_cb);

        clearCB = findViewById(R.id.clear_cb);
        rememberCB = findViewById(R.id.remeber_finger);

        SharedPreferences sharedPreferences = getSharedPreferences(this.getPackageName(), Context.MODE_PRIVATE);
        appIdET.setText(sharedPreferences.getString("poc-finger-appId", ""));
        appSecET.setText(sharedPreferences.getString("poc-finger-appSec", ""));
        tokenUrlET.setText(sharedPreferences.getString("poc-finger-tokenUrl", "http://"));
    }

    public void initEvent() {

        showBT.setOnClickListener(v -> {

            try {
                PackageManager pm = v.getContext().getPackageManager();
                Collection<PackageInfo> packageInfos = pm.getInstalledPackages(0);
                App.riskSdk.updateAppList(packageInfos);
                App.riskSdk.setAllowPrivacyList(PrivacyFlag.ALL);

            } catch (Exception e) {
                e.printStackTrace();
            }
            showBT.setEnabled(false);

            InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            // 隐藏软键盘
            imm.hideSoftInputFromWindow(getWindow().getDecorView().getWindowToken(), 0);

            String text_appId = appIdET.getText().toString();
            String text_appSec = appSecET.getText().toString();
            String text_tokenUrl = tokenUrlET.getText().toString();

            // remember me
            {
                SharedPreferences sharedPreferences = getSharedPreferences(AllFingerDemo.this.getPackageName(), Context.MODE_PRIVATE);
                SharedPreferences.Editor editor = sharedPreferences.edit();

                if (rememberCB.isChecked()) {
                    editor.putString("poc-finger-appId", text_appId);
                    editor.putString("poc-finger-appSec", text_appSec);
                    editor.putString("poc-finger-tokenUrl", text_tokenUrl);
                } else {
                    editor.putString("poc-finger-appId", "");
                    editor.putString("poc-finger-appSec", "");
                    editor.putString("poc-finger-tokenUrl", "");
                }

                editor.commit();
            }

            mAppId = text_appId.isEmpty() ? sAppId : text_appId;
            mAppSecret = text_appSec.isEmpty() ? sAppSecret : text_appSec;
            mUrl = text_tokenUrl;

            if (mUrl.isEmpty() || mUrl.equals("http://")) {
                mTokenUrl = sUrl + "/udid/m1";
                mEngineUrl = sUrl + "/udid/api/getDeviceInfo";
            } else {
                mTokenUrl = mUrl + "/udid/m1";
                mEngineUrl = mUrl + "/udid/api/getDeviceInfo";
            }

            if (mTokenUrl.isEmpty() || mAppId.isEmpty()) {
                Toast.makeText(getBaseContext(), "url或者AppID 不可为空！", Toast.LENGTH_SHORT).show();
                showBT.setEnabled(true);
                return;
            }

            mRiskMap.clear();
            if (memdumpCB.isChecked())
                mRiskMap.put("PRIVATE_FAKE_MEMDUMP", "");
            if (injectCB.isChecked())
                mRiskMap.put("PRIVATE_FAKE_INJECT", "");
            if (debugCB.isChecked())
                mRiskMap.put("PRIVATE_FAKE_DEBUG", "");
            if (emulatorCB.isChecked())
                mRiskMap.put("PRIVATE_FAKE_EMULATOR", "");
            if (multirunCB.isChecked())
                mRiskMap.put("PRIVATE_FAKE_MULTIRUN", "");
            if (rootCB.isChecked())
                mRiskMap.put("PRIVATE_FAKE_ROOT", "");

            if (!clearCB.isChecked())
                mRiskMap.put("PRIVATE_CLEAR_TOKEN", "clear");

            detailTV.setText("");
            showTV.setText("");
            msgTV.setText("开始获取token。。。");

            detailTV.setText("---------- 请求信息 ----------\r\n");
            detailTV.append("appId    :" + mAppId + "\r\n");
            detailTV.append("appSec :" + mAppSecret + "\r\n");
            detailTV.append("risk url  :" + mTokenUrl + "\r\n");
            detailTV.append("info url  :" + mEngineUrl + "\r\n");

            showTV.setText("---------- 请求结果 ----------\r\n");

            new Thread() {
                @Override
                public void run() {


                    HashMap<String, String> params = new HashMap<String, String>();
                    if (!"saas".equals(mTokenUrl)) {
                        params.put(RiskSdk.KEY_URL, mTokenUrl);
                    }

                    params.putAll(mRiskMap);

                    Log.e(TAG, "mRiskMap:" + params.toString());

                    long startTime = System.currentTimeMillis();

                    params.put(RiskSdk.KEY_TIMEOUT_MS, "5000");

                    RiskApp riskApp = App.riskSdk.getRiskApp(mAppId);
                    riskApp.init(params);

                    final String token = riskApp.getToken();

                    Log.e(TAG, "token:" + token);
                    long stopTime = System.currentTimeMillis();

                    mSpendTime = (stopTime - startTime) + "ms";

                    runOnUiThread(() -> {
                        msgTV.setText("获取token完毕");

                        showTV.append("token\r\n" + token + "\r\n");
                        msgTV.setText("开始调用风控引擎。。。");

                        Log.e(TAG, "token:" + token);
                    });

                    try {
                        Thread.sleep(100);

                        FingerHelper.enqueueGetDeviceInfo(mEngineUrl, mAppId, mAppSecret, token, new Callback() {
                            @Override
                            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                                Log.e(TAG, "token:" + token, e);
                            }

                            @Override
                            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                                try (ResponseBody body = response.body()) {
                                    String deviceInfo = body.string();
                                    Log.e(TAG, "deviceInfo:" + deviceInfo);
                                    try {
                                        mDeviceInfo = new JSONObject(deviceInfo).toString(4);
                                    } catch (JSONException e) {
                                        throw new RuntimeException(e);
                                    }

                                    Log.e(TAG, "token:" + token);
                                    Log.e(TAG, "mDeviceInfo:" + mDeviceInfo);
                                }
                                runOnUiThread(() -> {
                                    msgTV.setText("调用DeviceInfo完毕");

                                    showBT.setEnabled(true);
                                    if (mDeviceInfo != null)
                                        showTV.append("- - - - - 模拟server - - - - - \r\n" + mDeviceInfo + "\r\n");
                                });
                            }
                        });
                    } catch (Exception e) {
                        Log.e(TAG, "msg: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }.start();
        });

    }

}