package risk.demo.bean;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author white
 * @description：
 * @date 2020-04-08
 */
public class Config {
    private String server = "";
    private String appID = "";
    private String appSecret = "";
    private String proCode = "";
    private String eventCode = "";
    private boolean cache = false;
    private String scene = "";

    static public Config toObject(String jsonStr) {
        try {
            if (jsonStr == null || jsonStr.length() == 0) {
                return null;
            }
            JSONObject json = new JSONObject(jsonStr);
            Config c = new Config();
            c.server = json.optString("server");
            c.appID = json.optString("appID");
            c.appSecret = json.optString("appSecret");
            c.proCode = json.optString("proCode");
            c.eventCode = json.optString("eventCode");
            c.cache = json.optBoolean("cache");
            c.scene = json.optString("scene");
            return c;
        } catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    String toJsonString() throws JSONException {
        JSONObject obj = new JSONObject();

        obj.put("server", server);
        obj.put("appID", appID);
        obj.put("appSecret", appSecret);
        obj.put("proCode", proCode);
        obj.put("eventCode", eventCode);
        obj.put("cache", cache);
        obj.put("scene", scene);
        return obj.toString(4);
    }


    public String getServer() {
        return server;
    }

    public Config setServer(String server) {
        this.server = server;
        return this;
    }

    public String getAppID() {
        return appID;
    }

    public Config setAppID(String appID) {
        this.appID = appID;
        return this;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public Config setAppSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public String getProCode() {
        return proCode;
    }

    public Config setProCode(String proCode) {
        this.proCode = proCode;
        return this;
    }

    public String getEventCode() {
        return eventCode;
    }

    public Config setEventCode(String eventCode) {
        this.eventCode = eventCode;
        return this;
    }

    public boolean isCache() {
        return cache;
    }

    public Config setCache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }
}
