package risk.demo.bean;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;

import org.json.JSONException;

import risk.demo.utils.ContextFinder;
import risk.demo.utils.FileUtil;

/**
 * @author white
 * @description：
 * @date 2020-04-08
 */
public class ConfigManager {

    private static final String KEY_CONFIG = "KEY_CONFIG";

    static Config mConfig;

    public static Config getConfig() {
        if (mConfig == null) {
            mConfig = loadConfig();
        }
        return mConfig;
    }

    public static void saveConfig(Config config) {
        mConfig = config;
        if (!TextUtils.isEmpty(mConfig.getServer()) && !mConfig.getServer().startsWith("http")) {
            mConfig.setServer("http://" + mConfig.getServer());
        }
        SharedPreferences sp = ContextFinder.getApplication().getSharedPreferences("config", Context.MODE_PRIVATE);
        try {
            sp.edit().putString(KEY_CONFIG, config.toJsonString()).commit();
        } catch (JSONException e) {
            Log.e("R", "e", e);
        }
    }

    public static Config loadConfig() {
        SharedPreferences sp = ContextFinder.getApplication().getSharedPreferences("config", Context.MODE_PRIVATE);
        String configStr = sp.getString(KEY_CONFIG, "");
        if (TextUtils.isEmpty(configStr)) {
            configStr = FileUtil.getAssetsConfigFile("config.json");
        }
        Config config = Config.toObject(configStr);
        if (config == null) {
            config = new Config();
            config.setServer("http://118.25.100.104:7801");
            config.setAppID("c3a4c14112b649910a3a55261a5f35e5");
            config.setAppSecret("f8ce107f873a29efcfa8ae2a4047b777");
            config.setScene("default");
            // config.setEventCode("awareness");
        }
        return config;
    }


}
