package risk.demo.ctu;

import android.Manifest;
import android.util.Base64;
import android.util.Log;

import org.json.JSONObject;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;

import risk.demo.ctu.model.CtuRequest;
import risk.demo.ctu.util.InputStreamUtils;
import risk.demo.ctu.util.SignUtil;
import risk.demo.utils.PermissionUtils;

public class CtuClient {
    private String url;           // 风险防控服务URL
    private String appKey;        // 颁发的公钥,可公开
    private String appSecret;     // 颁发的秘钥,严禁公开,请保管好,千万不要泄露!
    private int connectTimeout = 3000;
    private int connectionRequestTimeout = 1000;
    private int socketTimeout = 5000;
    private static final String UTF8_ENCODE = "UTF-8";
    private static final Integer version = 1; //client版本号  从1开始

    public CtuClient(String url, String appKey, String appSecret) {
        this.url = url;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public CtuClient(String url, String appKey, String appSecret, int connectTimeout,
                     int connectionRequestTimeout, int socketTimeout) {
        this.url = url;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.connectTimeout = connectTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.socketTimeout = socketTimeout;
    }

    public String checkRisk(CtuRequest request) throws Exception {
        String sign = SignUtil.sign(appSecret, request);
        String reqUrl = String.format("%s?appKey=%s&sign=%s&version=%s", url, appKey, sign,version);

        //String reqJsonString = JSON.toJSONString(request, SerializerFeature.WriteMapNullValue);
        // tmp
        JSONObject reqJson = new JSONObject();

        reqJson.put("data", new JSONObject(request.getData()));
        reqJson.put("eventCode", request.getEventCode());
        reqJson.put("flag", request.getFlag());

        String reqJsonString = reqJson.toString();

        byte[] base64Requst = Base64.encode(reqJsonString.getBytes(UTF8_ENCODE), Base64.DEFAULT);

        return httpRequest(reqUrl, base64Requst);
    }

    public static String httpRequest(String url, byte[] data) {

        if (!PermissionUtils.checkPermissions(Manifest.permission.INTERNET)) {
            return null;
        }

        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream in = null;

        String result = null;

        try {

            URL readl_url = new URL(url);

            conn = (HttpURLConnection) readl_url.openConnection(Proxy.NO_PROXY);
            conn.setConnectTimeout(15 * 1000);
            conn.setReadTimeout(15 * 1000);

            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "keep-Alive");
            conn.setRequestProperty("User-Agent", "STEE-SDK");
            conn.setRequestProperty("Content-type", "application/octet-stream");

            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);

            out = new DataOutputStream(conn.getOutputStream());
            out.write(data);
            out.flush();

            int responseCode = conn.getResponseCode();

            if (responseCode == HttpURLConnection.HTTP_OK) {
                result = InputStreamUtils.readToString(conn.getInputStream());
            }

        } catch (Throwable e) {
            Log.e("DXDemo", "fail on fetching " + url, e);
        } finally {

            try {

                if (in != null) {
                    in.close();
                }

                if (out != null) {
                    out.close();
                }

                if (conn != null) {
                    conn.disconnect();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return result;
    }
}
