package risk.demo.ctu.util;


import java.util.Map;
import java.util.TreeMap;

import risk.demo.ctu.model.CtuRequest;

/**
 * Created by zxkletters on 2017/5/5.
 */
public class SignUtil {
    private static final String EVENT_CODE = "eventCode";
    private static final String FLAG = "flag";
    private static final String DATA = "data";
    private static final String UTF8_ENCODE = "UTF-8";

    /**
     * 签名请求
     *
     * @param appSecret
     * @param ctuRequest
     * @return
     */
    public static String sign(String appSecret, CtuRequest ctuRequest) {
        String sortedParams = sortedParams(ctuRequest);

        // 数据签名
        String s = appSecret + sortedParams + appSecret;
        return MD5Utils.md5_hex(s.getBytes());

    }

    private static String sortedParams(CtuRequest request) {
        String eventCode = request.getEventCode();
        String flag = request.getFlag();
        Map<String, Object> data = new TreeMap<String, Object>(request.getData());

        StringBuilder sb = new StringBuilder(200);
        sb.append(EVENT_CODE).append(eventCode).append(FLAG).append(flag);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            sb.append(entry.getKey()).append(entry.getValue());
        }
        return sb.toString();
    }
}
