package risk.demo.ui;

import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;

import com.dx.mobile.risk.RiskApp;
import com.dx.mobile.risk.RiskSdk;

import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import risk.demo.App;
import risk.demo.R;
import risk.demo.bean.Config;
import risk.demo.bean.ConfigManager;
import risk.demo.ctu.CtuClient;
import risk.demo.ctu.model.CtuRequest;

/**
 * @author white
 * @description：
 * @date 2020-04-07
 */
public class CtuFragment extends Fragment {

    private static final String TAG = "RiskDemo";
    TableLayout mTableLayout;
    Button mBtnGet;
    View mLayoutNull;
    TextView mTvStatus;
    Handler mHandler;
    View mLayoutContent;
    ImageView mIvStatus;


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.fragment_risk, container, false);
        return root;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        TextView tvTtile = view.findViewById(R.id.titlebar_tv_title);
        tvTtile.setText("决策引擎");

        mTableLayout = view.findViewById(R.id.tablelayout);
        mLayoutContent = view.findViewById(R.id.layout_content);
        mLayoutContent.setVisibility(View.GONE);
        mTvStatus = view.findViewById(R.id.tv_status);
        mIvStatus = view.findViewById(R.id.iv_status);
        mLayoutNull = view.findViewById(R.id.layout_empty);
        mBtnGet = view.findViewById(R.id.btn_getToken);

        mBtnGet.setText("发送请求");
        mBtnGet.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onClickGet();
            }
        });

        mHandler = new Handler();
    }

    private void onClickGet() {
        Config config = ConfigManager.getConfig();
        if (TextUtils.isEmpty(config.getServer())
                || TextUtils.isEmpty(config.getAppID())
                || TextUtils.isEmpty(config.getAppSecret())) {
            Toast.makeText(getActivity(), "服务器地址/AppID/AppSecret为空", Toast.LENGTH_SHORT).show();
            return;
        }

        mBtnGet.setEnabled(false);

        mLayoutContent.setVisibility(View.VISIBLE);
        mLayoutNull.setVisibility(View.GONE);
        updateStatus("获取token...", R.mipmap.ic_status_ing);

        new Thread(new Runnable() {
            @Override
            public void run() {
                // 1. getToken
                HashMap<String, String> params = new HashMap<>();
                Config config = ConfigManager.getConfig();

                if (!config.isCache()) {
                    params.put("PRIVATE_CLEAR_TOKEN", "clear");
                }

                if (!TextUtils.isEmpty(config.getServer())) {
                    params.put(RiskSdk.KEY_URL, config.getServer());
                }
                // for poc gpu
                params.put(RiskSdk.KEY_TIMEOUT_MS, "10000");

                RiskApp riskApp = App.riskSdk.getRiskApp(config.getAppID());
                riskApp.init(params);
                final String token = riskApp.getToken();
                Log.i(TAG, "token:" + token);

                if (token.length() > 40 || token.isEmpty()) {
                    onGetFailed();
                    return;
                }


                // 2.getRisk
                updateStatus("获取风控信息...", R.mipmap.ic_status_ing);
                String result = doReqCtu(config, token);
                Log.i(TAG, "getCtu:" + result);

                try {
                    JSONObject jsonObj = new JSONObject(result);
                    onGetSuccess(jsonObj);
                } catch (Exception e) {
                    e.printStackTrace();
                    onGetFailed();
                }

            }
        }).start();



    }

    private void onGetFailed(){
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                mBtnGet.setEnabled(true);
                if (getActivity() != null){
                    Toast.makeText(getActivity(), "服务器连接失败/鉴权失败", Toast.LENGTH_SHORT).show();
                }
                updateStatus("服务器连接失败/鉴权失败", R.mipmap.ic_status_fail);
            }
        });
    }



    private void updateStatus(final String msg, final int resId){
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                String dateStr = sdf.format(new Date());
                mTvStatus.setText(dateStr + "  "+ msg);
                mIvStatus.setImageResource(resId);
            }
        });
    }

    private void onGetSuccess(final JSONObject jsonObj){
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                updateStatus("获取到风控返回结果", R.mipmap.ic_status_success);

                try {
//                    for(int i = 1; i < mTableLayout.getChildCount(); i++){
//                    }
                    mTableLayout.removeViews(1, mTableLayout.getChildCount() - 1);

                    JSONObject dataJson = jsonObj.getJSONObject("result");
                    Iterator<String> it = dataJson.keys();
                    while (it.hasNext()) {
                        String key = it.next();
                        mTableLayout.addView(getTableRow(key, dataJson.getString(key)));
                        mBtnGet.setEnabled(true);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    onGetFailed();
                }

            }
        });

    }

    private TableRow getTableRow(String name, String value) {
        TableRow tableRow = (TableRow)LayoutInflater.from(getContext()).inflate(R.layout.view_tablerow, (ViewGroup)getView(), false);
        TextView tvName = tableRow.findViewById(R.id.tv_name);
        TextView tvValue = tableRow.findViewById(R.id.tv_value);
        tvName.setText(name);
        tvValue.setText(value);

        return tableRow;
    }

    /**
     * 模拟风控业务请求
     * @param config
     * @param token
     * @return
     */
    public String doReqCtu(Config config, String token) {
        Map<String, Object> data = new HashMap<>();
        data.put("const_id", token); // 设备指纹id
        CtuRequest request = new CtuRequest();
        request.setEventCode(config.getEventCode());
        request.setData(data);
        request.setFlag("test");


        String url = config.getServer() + "/ctu/event.do";

        Log.i(TAG, "ctu url:" + url);
        CtuClient client = new CtuClient(url, config.getAppID(), config.getAppSecret());
        String result = null;
        try {
            result = client.checkRisk(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }


}
