package risk.demo.ui;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TabHost;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.List;

import risk.demo.R;

/**
 * @author white
 * @description：
 * @date 2019/4/6
 */
public class MainActivity extends FragmentActivity {
    private LayoutInflater mInflater;
    private List<MainTab> mTabs = new ArrayList<>();


    private risk.demo.ui.FragmentTabHost mTabhost;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        initPermission();
        try {
            getLocation();
        } catch (Exception ignore) {
        }
        initTab();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
    }

    private void initPermission() {
        // API 23或以上的动态申请权限
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            String[] permissionArray = {
                    "android.permission.ACCESS_COARSE_LOCATION",
                    "android.permission.ACCESS_FINE_LOCATION",
                    "android.permission.WRITE_EXTERNAL_STORAGE",
                    "android.permission.READ_EXTERNAL_STORAGE",
                    "android.permission.ACCESS_BACKGROUND_LOCATION",
                    "android.permission.READ_PHONE_STATE",
                    "android.permission.QUERY_ALL_PACKAGES",
            };
            for (String s : permissionArray) {
                if (ActivityCompat.checkSelfPermission(this, s)
                        != PackageManager.PERMISSION_GRANTED) {
                    this.requestPermissions(permissionArray, 1);
                    break;
                }
            }
        }
    }


    private void getLocation() {
        final LocationManager locationManager = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
        String provider = "";

        List<String> providerList = locationManager.getProviders(true);

        if (providerList.contains(LocationManager.NETWORK_PROVIDER)) { // 网络提供器
            provider = LocationManager.NETWORK_PROVIDER;
        } else if (providerList.contains(LocationManager.GPS_PROVIDER)) { // GPS提供器
            provider = LocationManager.GPS_PROVIDER;
        }
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return;
        } else {
            final String finalProvider = provider;
            new Thread(new Runnable() {
                @Override
                @SuppressLint("MissingPermission")
                public void run() {
                    while (true) {
                        Location location = locationManager.getLastKnownLocation(finalProvider);
                        try {
                            Thread.sleep(3000);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();

            locationManager.requestLocationUpdates(
                    LocationManager.GPS_PROVIDER, 3000, 50, new LocationListener() {
                        @Override
                        public void onLocationChanged(Location location) {

                        }

                        public void onStatusChanged(java.lang.String a, int b, android.os.Bundle c) {

                        }

                        @Override
                        public void onProviderEnabled(String provider) {

                        }

                        @Override
                        public void onProviderDisabled(String provider) {

                        }
                    }
            );

        }
    }

    private void initTab() {

        MainTab tab_risk = new MainTab(RiskFragment.class, R.string.tab_title_risk, R.drawable.selector_icon_risk);
        MainTab tab_ctu = new MainTab(CtuFragment.class, R.string.tab_title_ctu, R.drawable.selector_icon_ctu);
        MainTab tab_settings = new MainTab(SettingsFragment.class, R.string.tab_title_settings, R.drawable.selector_icon_settings);

        mTabs.add(tab_risk);
        mTabs.add(tab_ctu);
        mTabs.add(tab_settings);


        mInflater = LayoutInflater.from(this);
        mTabhost = this.findViewById(android.R.id.tabhost);
        mTabhost.setup(this, getSupportFragmentManager(), R.id.realtabcontent);
        for (MainTab tab : mTabs) {

            TabHost.TabSpec tabSpec = mTabhost.newTabSpec(getString(tab.getTitle()));

            tabSpec.setIndicator(buildIndicator(tab));

            mTabhost.addTab(tabSpec, tab.getFragment(), null);

        }

        mTabhost.setOnTabChangedListener(new TabHost.OnTabChangeListener() {
            @Override
            public void onTabChanged(String tabId) {
            }
        });

        mTabhost.getTabWidget().setShowDividers(LinearLayout.SHOW_DIVIDER_NONE);
        mTabhost.setCurrentTab(0);


    }

    private void updateAction(final String action, final String msg) {

        if ("exit".equalsIgnoreCase(action)) {
            if (!TextUtils.isEmpty(msg)) {
                Toast.makeText(MainActivity.this, msg, Toast.LENGTH_LONG).show();
            }
            finish();
        } else if ("relogin".equalsIgnoreCase(action)) {
            Toast.makeText(MainActivity.this, "todo relogin", Toast.LENGTH_LONG).show();
        } else if ("logout".equalsIgnoreCase(action)) {
            Toast.makeText(MainActivity.this, "todo logout", Toast.LENGTH_LONG).show();
        } else if ("normal".equalsIgnoreCase(action)) {
            Toast.makeText(MainActivity.this, "环境正常", Toast.LENGTH_LONG).show();
            Log.e("RiskFragment", "normal");
        }
    }


    private View buildIndicator(MainTab tab) {

        View view = mInflater.inflate(R.layout.main_tab_indicator, null);
        ImageView img = view.findViewById(R.id.icon_tab);
        TextView text = view.findViewById(R.id.txt_indicator);

        img.setBackgroundResource(tab.getIcon());
        text.setText(tab.getTitle());

        return view;
    }


    @Override
    public void onBackPressed() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(mTabhost.getCurrentTabTag());
        if (fragment instanceof SettingsFragment) {
            if (((SettingsFragment) fragment).onBackPressed()) {
                return;
            }
        }
        super.onBackPressed();
    }


    @Override
    protected void onStart() {
        super.onStart();
    }


    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }


}
