
package risk.demo.ui;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;

import com.dx.mobile.risk.RiskApp;
import com.dx.mobile.risk.RiskSdk;
import com.dx.mobile.risk.RiskSituation;
import com.dx.mobile.risk.RiskSituationEventHandler;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import risk.demo.App;
import risk.demo.R;
import risk.demo.bean.Config;
import risk.demo.bean.ConfigManager;
import risk.demo.utils.FingerHelper;

/**
 * @author white
 * @description：
 * @date 2020-04-07
 */
public class RiskFragment extends Fragment {

    private static final String TAG = "RiskDemo";
    TableLayout mTableLayout;
    Button mBtnGet;
    View mLayoutNull;
    TextView mTvStatus;
    Handler mHandler;
    View mLayoutContent;
    ImageView mIvStatus;
    private Button mBtnSituation;


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.fragment_risk, container, false);
        return root;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        TextView tvTtile = view.findViewById(R.id.titlebar_tv_title);
        tvTtile.setText("设备指纹");

        mTableLayout = view.findViewById(R.id.tablelayout);
        mLayoutContent = view.findViewById(R.id.layout_content);
        mLayoutContent.setVisibility(View.GONE);
        mTvStatus = view.findViewById(R.id.tv_status);
        mIvStatus = view.findViewById(R.id.iv_status);
        mLayoutNull = view.findViewById(R.id.layout_empty);
        mBtnGet = view.findViewById(R.id.btn_getToken);
        mBtnSituation = view.findViewById(R.id.btn_getSituation);
        mBtnSituation.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onSituation();
            }
        });
        mBtnGet.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onClickGet();
            }
        });

        mHandler = new Handler();
    }


    private void onClickGet() {
        Config config = ConfigManager.getConfig();
        if (TextUtils.isEmpty(config.getServer())
                || TextUtils.isEmpty(config.getAppID())
                || TextUtils.isEmpty(config.getAppSecret())) {
            Toast.makeText(getActivity(), "服务器地址/AppID/AppSecret为空", Toast.LENGTH_SHORT).show();
            return;
        }

        try {
            PackageManager pm = getActivity().getPackageManager();
            Collection<PackageInfo> packageInfos = pm.getInstalledPackages(0);
            App.riskSdk.updateAppList(packageInfos);
        } catch (Exception e) {
            e.printStackTrace();
        }

        mBtnGet.setEnabled(false);

        mLayoutContent.setVisibility(View.VISIBLE);
        mLayoutNull.setVisibility(View.GONE);
        updateStatus("获取token...", R.mipmap.ic_status_ing);

        new Thread(() -> {
            // 1. getToken
            Config config1 = ConfigManager.getConfig();
            Map<String, String> params = buildConfig(config1);

            RiskApp riskApp = App.riskSdk.getRiskApp(config1.getAppID());
            riskApp.init(params);

            final String token = riskApp.getToken();
            Log.i(TAG, "token:" + token);
//
//                if (token.length() > 40 || token.isEmpty()) {
//                    onGetFailed();
//                    return;
//                }
            RiskSituation situation = riskApp.getRiskSituation();
            situation.setSituationEventHandler(new RiskSituationEventHandler() {
                @Override
                public void onClientEvent(RiskSituation riskSituation, int i, int i1, String s) {
                    riskSituation.scheduleUpdateSituation(5 * 1000);
                }

                @Override
                public void onServerEvent(RiskSituation riskSituation, String action, String msg) {
                    riskSituation.endScene();
                    if (!TextUtils.isEmpty(action)) {
                        updateAction(action, msg);
                    }
                }
            });
            situation.beginScene(config1.getScene());

            situation.scheduleUpdateSituation();

            // 2.getDeviceInfo

            updateStatus("获取设备信息...", R.mipmap.ic_status_ing);
            String url = config1.getServer() + "/udid/api/getDeviceInfo";
            try {
                FingerHelper.enqueueGetDeviceInfo(url, config1.getAppID(), config1.getAppSecret(), token, new Callback() {
                    @Override
                    public void onFailure(@NotNull Call call, @NotNull IOException e) {

                    }

                    @Override
                    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                        try (ResponseBody body = response.body()) {
                            String deviceInfo = body.string();
                            Log.e(TAG, "deviceInfo:" + deviceInfo);
                            JSONObject jsonObj = null;
                            try {
                                jsonObj = new JSONObject(deviceInfo);
                            } catch (JSONException e) {
                                throw new IOException(e);
                            }
                            onGetSuccess(jsonObj);
                        }

                    }
                });

            } catch (Exception e) {
                e.printStackTrace();
                onGetFailed();
            }


        }).start();
    }

    private static Map<String, String> buildConfig(Config config1) {
        HashMap<String, String> params = new HashMap<>();
        if (!config1.isCache()) {
            params.put("PRIVATE_CLEAR_TOKEN", "clear");
        }

        if (!TextUtils.isEmpty(config1.getServer())) {
            params.put(RiskSdk.KEY_URL, config1.getServer() + "/udid/m1");
            params.put(RiskSdk.KEY_SITUATION_URL, config1.getServer() + "/udid/sa-m");
        }
        params.put(RiskSdk.KEY_TIMEOUT_MS, "10000");
        return params;
    }


    private void onSituation() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                Config config = ConfigManager.getConfig();
                RiskApp riskApp = App.riskSdk.getRiskApp(config.getAppID());
                riskApp.init(buildConfig(config));
                RiskSituation situation = riskApp.getRiskSituation();
                situation.setSituationEventHandler(new RiskSituationEventHandler() {
                    @Override
                    public void onClientEvent(RiskSituation riskSituation, int i, int i1, String s) {
                        riskSituation.scheduleUpdateSituation(5 * 1000);
                    }

                    @Override
                    public void onServerEvent(RiskSituation riskSituation, String action, String msg) {
                        situation.endScene();
                        if (!TextUtils.isEmpty(action)) {
                            updateAction(action, msg);
                        }
                    }
                });
                situation.beginScene("active-situation");
                situation.scheduleUpdateSituation();
                mBtnSituation.setVisibility(View.VISIBLE);
            }
        }).start();
    }


    private void onSituationFailed() {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                mBtnGet.setEnabled(true);
                if (getActivity() != null) {
                    Toast.makeText(getActivity().getApplicationContext(), "updateSituation result is null", Toast.LENGTH_SHORT).show();
                }
            }
        });
    }

    private void onGetFailed() {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                mBtnGet.setEnabled(true);
                if (getActivity() != null) {
                    Toast.makeText(getActivity().getApplicationContext(), "服务器连接失败/鉴权失败", Toast.LENGTH_SHORT).show();
                }
                updateStatus("服务器连接失败/鉴权失败", R.mipmap.ic_status_fail);
            }
        });
    }


    private void updateStatus(final String msg, final int resId) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                String dateStr = sdf.format(new Date());
                mTvStatus.setText(dateStr + "  " + msg);
                mIvStatus.setImageResource(resId);
            }
        });
    }

    private void updateAction(final String action, final String msg) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                mBtnGet.setEnabled(true);
                mBtnSituation.setVisibility(View.VISIBLE);

                if (getActivity() == null) return;
                if ("crash".equalsIgnoreCase(action)) {
                    getActivity().finish();
                }
                if (!TextUtils.isEmpty(msg)) {
                    Toast.makeText(getActivity().getApplicationContext(), msg, Toast.LENGTH_LONG).show();
                }


            }

        });
    }

    private void onGetSuccess(final JSONObject jsonObj) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                updateStatus("获取设备指纹成功", R.mipmap.ic_status_success);

                try {
//                    for(int i = 1; i < mTableLayout.getChildCount(); i++){
//                    }
                    mTableLayout.removeViews(1, mTableLayout.getChildCount() - 1);

                    JSONObject dataJson = jsonObj.getJSONObject("data");
                    Iterator<String> it = dataJson.keys();
                    while (it.hasNext()) {
                        String key = it.next();
                        mTableLayout.addView(getTableRow(key, dataJson.getString(key)));
                        mBtnGet.setEnabled(true);
                        mBtnGet.setText("重新获取设备指纹");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    onGetFailed();
                }

            }
        });

    }

    private TableRow getTableRow(String name, String value) {
        TableRow tableRow = (TableRow) LayoutInflater.from(getActivity()).inflate(R.layout.view_tablerow, (ViewGroup) getView(), false);
        TextView tvName = tableRow.findViewById(R.id.tv_name);
        TextView tvValue = tableRow.findViewById(R.id.tv_value);
        tvName.setText(name);
        tvValue.setText(value);

        return tableRow;
    }


}
