package risk.demo.ui;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import risk.demo.R;
import risk.demo.bean.Config;
import risk.demo.bean.ConfigManager;

/**
 * @author white
 * @description：
 * @date 2020-04-07
 */
public class SettingsFragment extends Fragment {


    EditText mEtAppID, mEtAppSecret, mEtServer, mEtProCode, mEtEventCode,mEtSceneCode;
    TextView mTvErrServer, mTvErrAppid, mTvErrSecret;
  //  ToggleButton mTbCache;
    Button mBtnSave;

    EditText mEtUpload;
    View mLayoutMain, mLayoutUpload, mBtnBack, mBtnJumpUpload;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.fragment_settings, container, false);
        return root;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


        TextView tvTtile = view.findViewById(R.id.titlebar_tv_title);
        tvTtile.setText("设置");
        mBtnJumpUpload = view.findViewById(R.id.titlebar_iv_right);
        mBtnJumpUpload.setVisibility(View.VISIBLE);
        mBtnBack = view.findViewById(R.id.titlebar_iv_back);


        mLayoutMain = view.findViewById(R.id.layout_main);
        mLayoutUpload = view.findViewById(R.id.layout_upload);
        mEtUpload = view.findViewById(R.id.et_upload);
        mEtAppID = view.findViewById(R.id.et_appid);
        mEtAppSecret = view.findViewById(R.id.et_secret);
        mEtServer = view.findViewById(R.id.et_server);
        mEtProCode = view.findViewById(R.id.et_pro_code);
        mEtEventCode = view.findViewById(R.id.et_event_code);
        mEtSceneCode = view.findViewById(R.id.et_setSene);

       // mTbCache = view.findViewById(R.id.tb_cache);
        mBtnSave = view.findViewById(R.id.btn_save);
        mTvErrServer = view.findViewById(R.id.tv_err_server);
        mTvErrAppid = view.findViewById(R.id.tv_err_appid);
        mTvErrSecret = view.findViewById(R.id.tv_err_appsecret);


//        mTbCache.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//            @Override
//            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
//            }
//        });

        mBtnJumpUpload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                // TODO
                mLayoutMain.setVisibility(View.GONE);
                mLayoutUpload.setVisibility(View.VISIBLE);
                mBtnBack.setVisibility(View.VISIBLE);
                mBtnJumpUpload.setVisibility(View.GONE);
            }
        });
        mBtnBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                mLayoutMain.setVisibility(View.VISIBLE);
                mLayoutUpload.setVisibility(View.GONE);
                mBtnBack.setVisibility(View.GONE);
                mBtnJumpUpload.setVisibility(View.VISIBLE);
            }
        });

        mBtnSave.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onClickSave();
            }
        });

        view.findViewById(R.id.btn_upload).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onClickUpload();
            }
        });

        initData();
    }

    private void onClickUpload() {
        if (mEtUpload.getText().length() == 0) {
            Toast.makeText(getContext(), "内容不可为空", Toast.LENGTH_SHORT).show();
            return;
        }
        String[] lines = mEtUpload.getText().toString().split("\n");
        Config config = new Config();
        try {
            config.setServer(lines[0]);
            config.setAppID(lines[1]);
            config.setAppSecret(lines[2]);
            config.setProCode(lines[3]);
            config.setEventCode(lines[4]);
        } catch (Exception e) {
        }

        ConfigManager.saveConfig(config);
        initData();
        Toast.makeText(getContext(), "上传设置成功", Toast.LENGTH_SHORT).show();
    }

    private void onClickSave() {
        mTvErrServer.setVisibility(View.GONE);
        mTvErrAppid.setVisibility(View.GONE);
        mTvErrSecret.setVisibility(View.GONE);
        if (mEtServer.getText().length() == 0) {
            mTvErrServer.setVisibility(View.VISIBLE);
            return;
        }
        if (mEtAppID.getText().length() == 0) {
            mTvErrAppid.setVisibility(View.VISIBLE);
            return;
        }
        if (mEtAppSecret.getText().length() == 0) {
            mTvErrSecret.setVisibility(View.VISIBLE);
            return;
        }

        Config config = new Config();
        config.setAppID(mEtAppID.getText().toString());
        config.setServer(mEtServer.getText().toString());
        config.setAppSecret(mEtAppSecret.getText().toString());
        config.setProCode(mEtProCode.getText().toString());
        config.setEventCode(mEtEventCode.getText().toString());
      //  config.setCache(mTbCache.isChecked());
        config.setEventCode(mEtSceneCode.getText().toString());
        ConfigManager.saveConfig(config);

        Toast.makeText(getContext(), "设置成功", Toast.LENGTH_SHORT).show();
    }

    private void initData() {
        Config config = ConfigManager.getConfig();
        mEtServer.setText(config.getServer());
        mEtAppID.setText(config.getAppID());
        mEtAppSecret.setText(config.getAppSecret());
        mEtProCode.setText(config.getProCode());
        mEtEventCode.setText(config.getEventCode());
    //    mTbCache.setChecked(config.isCache());
        mEtSceneCode.setText(config.getScene());
    }

    public boolean onBackPressed(){
        if (mLayoutUpload.getVisibility() == View.VISIBLE) {
            mBtnBack.performClick();
            return true;
        }
        return false;
    }


}
