package risk.demo.utils;

import android.content.Context;

/**
 * 
 * 通过静态方式获取当前的Application实例，兼容范围(1.6-7.1)
 * 
 * @author boyliang
 *
 */
public final class ContextFinder {
	private static volatile Context sContext; 

	public static synchronized Context getApplication(){
		return sContext;
	}

	public static void setTokenContext(Context context){
		sContext = context;
	}
}
