package risk.demo.utils;

import android.util.Log;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import risk.demo.ctu.util.MD5Utils;

/**
 * Created by blue on 2019/1/8.
 */

public class FingerHelper {
    static OkHttpClient client;

    static {
        OkHttpClient.Builder b = new OkHttpClient.Builder();
        try {
            TrustAllManager trustManager = new TrustAllManager();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();

            b.hostnameVerifier((hostname, session) -> true)
                    .sslSocketFactory(sslSocketFactory, trustManager);
        } catch (Exception e) {
            Log.e("R", "", e);
        }
        client = b.build();
    }

    public static void enqueueGetDeviceInfo(String url, String appId, String appSecret, String token, Callback cb) throws Exception {

        //服务器  ：服务器项目  ：servlet名称
        // url?appId=xxxxx&token=urlencode(token)&sign=md5(appSecret + token + appSecret)


        HttpUrl httpUrl = HttpUrl.parse(url).newBuilder().addQueryParameter("appId", appId)
                .addQueryParameter("token", token)
                .addQueryParameter("sign", MD5Utils.md5_hex((appSecret + token + appSecret).getBytes("UTF-8")))
                .build();
        Request req = new Request.Builder().url(httpUrl).build();

        client.newCall(req).enqueue(cb);
    }

    public static class TrustAllManager implements X509TrustManager {

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[]{};
        }
    }
}
